% Generating direction vectors from the noise sphere to ground (for ray tracing)

r = generateRays();
save('RayTracingRays.mat', 'r');




function Rays = generateRays()

center_sky = [0, 0, 20]; 
center_ground = [0, 0, 0];
radius = 5;

num_circles = 4;
points_per_circle = 5;

inside_points = generate_points_inside_circle(center_ground, radius, num_circles, points_per_circle);

ground_points = inside_points(:, 1:2); 

Rays = (inside_points - center_sky)./vecnorm((inside_points - center_sky)')';


figure;
hold on;

for i = 1:size(ground_points, 1)
    quiver3(center_sky(1), center_sky(2), center_sky(3), Rays(i,1), Rays(i,2), Rays(i,3), 'b');
end

view(3)
view(-30, 30);
camlight('headlight');
lighting gouraud;
grid on;
xlabel('X [m]');
ylabel('Y [m]');
zlabel('Z [m]');


figure

plot(ground_points(:, 1), ground_points(:, 2), 'bo', 'DisplayName', 'Ground Points');
hold off;
axis equal;
xlabel('X [m]');
ylabel('Y [m]');
title('Collison Points of Unobstructed Rays on the Ground'); 

grid off;
end

function points = generate_points_inside_circle(center, radius, num_circles, points_per_circle)
points = [];
for i = 1:num_circles
    num_points = points_per_circle * i;
    theta = linspace(0, 2*pi, num_points)';
    x = center(1) + i * radius * cos(theta);
    y = center(2) + i * radius * sin(theta);
    z = center(3) * ones(num_points, 1);  
    points = [points; [x, y, z]];
end
end

